#include <iostream>
#include <unordered_set>
#include <string>
#include <vector>

class FenwickTree{
    public:
    FenwickTree(int n): n(n), tree(n+1,0){}
    void azuriraj(int indeks, int vrednost){
        for(; indeks<=n, indeks+=indeks & -indeks){
            tree[indeks]^=vrednost;
        }
    }
    int ispitati(int indeks){
        int rez=0;
        for(; indeks>o; indeks-=indeks & -indeks){
            rez^=tree[indeks];
        }
        return rez;
    }
    private:
    int n;
    std::vector<int>tree;
};
int main(){
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(0), std::cout.tie(0);
    std::string poruka;
    std::cin>>poruka;
    int n=poruka.size();
    FenwickTree fenwick(n);
    std::unordered_set<std::string> razlreci;
    razlreci.insert(poruka);
    for(int i=0; i<n; ++i){
        fenwick.azuriraj(i+1, poruka[i]-'0');
        for(int j=i; j<n; ++j){
            int xorv=fenwick.ispitati(j+1)^fenwick.ispitati(i);
            std::string novar=pouka.substr(0,i)+(char)(xov+'0')+poruka.substr(j+1);
            razlreci.insert(novar);
        }
    }

    std::cout<<razlreci.size()%998244353;
    return 0;
}